/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public record CasterTomeData(String name, List<ResourceLocation> spell, ResourceLocation tomeType, String flavorText, ParticleColor particleColor, ConfiguredSpellSound sound) implements SpecialSingleInputRecipe
{
    public CasterTomeData(String name, List<ResourceLocation> spell, ResourceLocation type, String flavorText, CompoundTag particleColor, ConfiguredSpellSound sound) {
        this(name, spell, type, flavorText, ParticleColorRegistry.from(particleColor), sound);
    }

    public static ItemStack makeTome(Item tome, String name, Spell spell, String flavorText) {
        ItemStack stack = tome.getDefaultInstance();
        AbstractCaster<?> spellCaster = SpellCasterRegistry.from(stack);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE).withItalic(Boolean.valueOf(true))));
        ((AbstractCaster)((AbstractCaster)spellCaster.setSpell(spell)).setFlavorText(flavorText)).saveToStack(stack);
        return stack;
    }

    public boolean matches(SingleRecipeInput p_346065_, Level p_345375_) {
        return false;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider p_267052_) {
        Item tomeType = (Item)BuiltInRegistries.ITEM.get(this.tomeType);
        if (tomeType == Items.AIR) {
            tomeType = ItemsRegistry.CASTER_TOME.asItem();
        }
        Spell.Mutable spell = new Spell().mutable();
        spell.name = this.name;
        if (this.particleColor != null) {
            spell.color = this.particleColor;
        }
        for (ResourceLocation rl : this.spell) {
            AbstractSpellPart part = GlyphRegistry.getSpellpartMap().get(rl);
            if (part == null) continue;
            spell.recipe.add(part);
        }
        spell.sound = this.sound;
        return CasterTomeData.makeTome(tomeType, this.name, spell.immutable(), this.flavorText);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.CASTER_TOME_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.CASTER_TOME_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CasterTomeData> {
        public static MapCodec<CasterTomeData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(CasterTomeData::name), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("spell").forGetter(CasterTomeData::spell), (App)ResourceLocation.CODEC.fieldOf("tome_type").forGetter(CasterTomeData::tomeType), (App)Codec.STRING.fieldOf("flavour_text").forGetter(CasterTomeData::flavorText), (App)ParticleColor.CODEC.fieldOf("color").forGetter(CasterTomeData::particleColor), (App)ConfiguredSpellSound.CODEC.fieldOf("sound").forGetter(CasterTomeData::sound)).apply((Applicative)instance, CasterTomeData::new));
        public static StreamCodec<RegistryFriendlyByteBuf, CasterTomeData> STREAM = CheatSerializer.create(CODEC);

        public MapCodec<CasterTomeData> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CasterTomeData> streamCodec() {
            return STREAM;
        }
    }
}

